#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Projective Conic EnvelopeMod01.fsh  by  mla
//https://www.shadertoy.com/view/Ws2cRh
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

////////////////////////////////////////////////////////////////////////////////
//
// Projective Conic Envelope
//
// Copyright (c) Matthew Arcus, 2020
// MIT License: https://opensource.org/licenses/MIT
//
// More projective magic - generate an ellipse as an envelope of lines.
// In fact, we start with the ellipse and find a network of lines
// enveloping it: at each point p, find tangents to the ellipse,
// intersect these with a fixed axis at x = -3 - this will be the
// source of the rays. From axis intersection point, map to a radial
// parameter, then find closest displayed ray, map that back to the
// axis and find the tangents from there & these are the lines that
// actually get displayed.
//
// Mouse changes size and orientation of ellipse.
//
////////////////////////////////////////////////////////////////////////////////

const float PI =  3.141592654;

vec3 join(vec3 p, vec3 q) {
  // Return either intersection of lines p and q
  // or line through points p and q, r = kp + jq
  return cross(p,q);
}

float line(vec3 p, vec3 q) {
  return abs(dot(p,q)/(p.z*length(q.xy)));
}

// Set tan1 and tan2 to the two tangents to conic X from point p.
// Return false if no tangents (eg. inside an ellipse).
bool tangents(vec3 p, mat3 X, out vec3 tan1, out vec3 tan2) {
  vec3 polar = X*p; // Line between tangents
  float a = polar.x, b = polar.y, c = polar.z;
  // Two points on the polar line. Q is the nearest point to origin,
  // R is at infinity, ie. is direction vector.
  vec3 Q = vec3(a,b,-(a*a+b*b)/c);
  vec3 R = vec3(-b,a,0);

  // Find intersection of QR with conic, ie. dot(Q+kR,X*(Q+kR)) = 0
  float A = dot(R,X*R), B = dot(Q,X*R), C = dot(Q,X*Q);
  float D = B*B-A*C;
  if (D < 0.0) return false;
  D = sqrt(D);
  float k1,k2;
  if (B > 0.0) {
    k1 = (-B-D)/A; k2 = C/(A*k1);
  } else {
    k2 = (-B+D)/A; k1 = C/(A*k2);
  }
  tan1 = join(p,Q+k1*R); tan2 = join(p,Q+k2*R);
  return true;
}

vec3 hsv2rgb( in vec3 c ) {
  vec3 rgb = clamp( abs(mod(c.x*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0 );
  rgb = rgb*rgb*(3.0-2.0*rgb); // cubic smoothing	
  return c.z * mix( vec3(1.0), rgb, c.y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  float scale = 3.0;
  float t = 0.2*iTime+PI/6.0;
  float A = 0.25, B = 1.0;
  if (iMouse.x > 0.0) {
    vec2 m = (2.0*iMouse.xy-iResolution.xy)/iResolution.y;
    t += PI*(m.y);
    B = exp(-m.x);
  }
  float cost = cos(t), sint = sin(t);
  // Conic matrix - conic is points p with pXp = 0
  mat3 X = mat3(A,0,0,0,B,0,0,0,-1);
  // Apply tranformation to conic matrix.
  mat3 P = mat3(cost,sint,0, -sint,cost,0, 0,0,1);
  X = transpose(P)*X*P;

  vec3 p = vec3(scale*(2.0*fragCoord - iResolution.xy)/iResolution.y,1);

  vec3 col = vec3(0);
  
  float lwidth0 = 0.0;
  float lwidth1 = max(0.02,fwidth(p.x));

  vec3 tan1,tan2,tan11,tan12,tan21,tan22;
  if (tangents(p,X,tan1,tan2)) {
    float N = 64.0;
    vec3 axis = vec3(1,0,3);
    float index1,index2;

    vec3 p1 = join(tan1,axis);
    float t1 = atan(p1.y/p1.z);
    t1 += 0.1*iTime;
    t1 *= N/PI; t1 = round(t1); index1 = t1; t1 *= PI/N;
    t1 -= 0.1*iTime;
    p1 = vec3(-3,tan(t1),1);
    p1.y = sign(p1.y)*min(abs(p1.y),1e4); // Fix up silly values
    if (tangents(p1,X,tan11,tan12)) {
      vec3 c1 = hsv2rgb(vec3(index1/N,1,1));
      float d = line(p,tan11);
      col = mix(c1,col,smoothstep(lwidth0,lwidth1,d));
      float tt = dot(normalize(tan2.xy),normalize(tan12.xy));
      // Try not to get the wrong tangent here. There must be a better
      // way of doing this.
      if (abs(tt) < 0.99) {
        d = line(p,tan12);
        col = mix(c1,col,smoothstep(lwidth0,lwidth1,d));
      }
    }

    vec3 p2 = join(tan2,axis);
    float t2 = atan(p2.y/p2.z);
    t2 += 0.1*iTime;
    t2 *= N/PI; t2 = round(t2); index2 = t2; t2 *= PI/N;
    t2 -= 0.1*iTime;
    p2 = vec3(-3,tan(t2),1);
    p2.y = sign(p2.y)*min(abs(p2.y),1e4); // Fix up silly values
    if (tangents(p2,X,tan21,tan22)) {
      vec3 c2 = hsv2rgb(vec3(index2/N,1,1));
      float d = line(p,tan22);
      col = mix(c2,col,smoothstep(lwidth0,lwidth1,d));
      float tt = dot(normalize(tan1.xy),normalize(tan21.xy));
      // Try not to get the wrong tangent here.
      if (abs(tt) < 0.99) {
        d = line(p,tan21);
        col = mix(c2,col,smoothstep(lwidth0,lwidth1,d));
      }
    }
  }
  col = pow(col,vec3(0.4545));
  fragColor = vec4(col,1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

